import { Component, OnInit } from '@angular/core'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { ActiveState } from '../../core/activestate/activestate.service'
import { Product } from '../../core/maincontent/product'

@Component({
  selector: 'app-epharmacy-home',
  templateUrl: './epharmacy-home.component.html',
  styleUrls: ['./epharmacy-home.component.css']
})
export class EpharmacyHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(public activeState: ActiveState,
          private mcService: MainContentService) {
    this.maincontentService = mcService
  }

  ngOnInit() {
    this.maincontentService.getProduct('epharmacy').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
